// script.js — nav toggle, year insert, gallery filter & modal, contact placeholder
document.addEventListener('DOMContentLoaded', function(){
  // Insert current year into any element with data-year
  document.querySelectorAll('[data-year]').forEach(el => el.textContent = new Date().getFullYear());

  // Nav toggles (centered nav; each page has one .nav-toggle and .main-nav)
  document.querySelectorAll('.nav-toggle').forEach(btn => {
    btn.addEventListener('click', () => {
      const nav = btn.closest('.site-header').querySelector('.main-nav');
      if(!nav) return;
      nav.classList.toggle('show');
    });
  });

  // Gallery filter (if galleryGrid present)
  const galleryGrid = document.getElementById('galleryGrid');
  if(galleryGrid){
    const filterBtns = document.querySelectorAll('.gallery-controls [data-filter]');
    filterBtns.forEach(b => {
      b.addEventListener('click', () => {
        const f = b.getAttribute('data-filter');
        galleryGrid.querySelectorAll('.gallery-item').forEach(item => {
          if(f === 'all' || item.dataset.category === f) item.style.display = '';
          else item.style.display = 'none';
        });
      });
    });

    // click-to-enlarge
    const modal = document.getElementById('imgModal');
    const modalImg = document.getElementById('modalImg');
    const modalClose = document.getElementById('modalClose');
    galleryGrid.querySelectorAll('.gallery-item img').forEach(img => {
      img.addEventListener('click', () => {
        modalImg.src = img.src;
        modal.style.display = 'flex';
      });
    });
    if(modalClose) modalClose.addEventListener('click', ()=> modal.style.display='none');
    if(modal) modal.addEventListener('click', (e)=>{ if(e.target === modal) modal.style.display='none'; });
  }

  // Contact placeholder behaviour
  document.querySelectorAll('.contact-form').forEach(form => {
    form.addEventListener('submit', (e) => {
      e.preventDefault();
      const status = form.querySelector('.status');
      if(status) status.textContent = 'Sending…';
      const btn = form.querySelector('button[type="submit"]');
      if(btn) btn.disabled = true;
      setTimeout(()=>{
        if(status) status.textContent = "Thanks — your message was received. We'll be in touch.";
        if(btn) btn.disabled = false;
        try{ form.reset(); }catch(e){}
      }, 900);
    });
  });
});
